<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function profiles()
    {
        return $this->hasMany('App\Classes\Profile');
    }

    public function game()
    {
        return $this->belongsTo('App\Classes\Game');
    }

}